#include "ExportController.h"
#include "../gui/export/CExportDialog.h"

#include <QFile>

#include "../models/treeModel/TagTreeControl.h"
#include "../models/data/TreeItem.h"
#include "../models/data/RootItem.h"
#include "../models/data/ReaderEntry.h"
#include "../models/data/AntennaEntry.h"
#include "../models/data/TagEntry.h"

ExportController::ExportController(TagTreeControl* tagTreeControl,
		QWidget* window, QObject* parent) :
	QObject(parent), m_window(window), m_tagTreeControl(tagTreeControl)
{
	m_exportDialog = new CExportDialog(this, window);
}

ExportController::~ExportController()
{

}

void ExportController::exportRequest ( )
{
	QString fileName = "TagList_" + QDateTime::currentDateTime().toString("yyyy_MM_dd-hh_mm") + ".csv";
	m_exportDialog->exec(fileName);
}

void ExportController::quickExportRequest ( )
{
	QString fileName = "TagList_" + QDateTime::currentDateTime().toString("yyyy_MM_dd-hh_mm") + ".csv";
	exportTagListToFile(m_exportDialog->lastExportPath() + "/" + fileName, m_exportDialog->lastExportFlags());
}

QString ExportController::lastError()
{
	return m_lastError;
}

int ExportController::exportTagListToFile(QString fileName, ulong exportFlags, QString delimiter)
{
	QFile f(fileName);
	f.open(QIODevice::ReadWrite);
	if (!f.isOpen())
	{
		m_lastError = tr("Could not open file");
		return -1;
	}

	QStringList tagList;
	QStringList header;
	header.append("Tag Id");

	if (exportFlags & TagTypeExportFlag)
		header.append("Tag Type");
	if (exportFlags & ReadCountExportFlag)
		header.append("Read Count");
	if (exportFlags & TimeStampExportFlag)
		header.append("Time Stamp");
	if (exportFlags & ReaderNameExportFlag)
		header.append("Reader Id");
	if (exportFlags & ReaderSerialExportFlag)
		header.append("Reader Serial");
    if (exportFlags & ReaderAntennaExportFlag)
        header.append("Reader Antenna");

	tagList.append(header.join(delimiter));

	RootItem* rootItem = m_tagTreeControl->rootItem();
	for (int i = 0; i < rootItem->childCount(); i++)
	{
		ReaderEntry* readerEntry = (ReaderEntry*) rootItem->child(i);
		for (int j = 0; j < readerEntry->childCount(); j++)
		{
            AntennaEntry* antennaEntry = 0;

            TreeItem* item = readerEntry->child(j);
            if(dynamic_cast<AntennaEntry*>(item) != 0)
            {
                antennaEntry = (AntennaEntry*) item;
                for (int j = 0; j < antennaEntry->childCount(); j++)
                {
                    TreeItem* item = antennaEntry->child(j);
                    if(dynamic_cast<TagEntry*>(item) != 0)
                    {
                        TagEntry* tagEntry = (TagEntry*) item;
                        QStringList entry = exportTag(exportFlags, readerEntry, antennaEntry, tagEntry);

                        tagList.append(entry.join(delimiter));
                    }
                }
            }
            if(dynamic_cast<TagEntry*>(item) != 0)
            {
                TagEntry* tagEntry = (TagEntry*) item;
                QStringList entry = exportTag(exportFlags, readerEntry, antennaEntry, tagEntry);

                tagList.append(entry.join(delimiter));
            }
		}
	}

	f.write(tagList.join("\n").toLatin1());

	f.close();

    return 0;
}

QStringList ExportController::exportTag(ulong exportFlags, ReaderEntry* readerEntry, AntennaEntry *antennaEntry, TagEntry *tagEntry)
{
    QStringList entry;

    entry.append(tagEntry->tagId());

    if (exportFlags & TagTypeExportFlag)
        entry.append(tagEntry->tagType());
    if (exportFlags & ReadCountExportFlag)
        entry.append(QString::number(tagEntry->readCount()));
    if (exportFlags & TimeStampExportFlag)
        entry.append(tagEntry->timeStampString());
    if (exportFlags & ReaderNameExportFlag)
        entry.append(readerEntry->readerName());
    if (exportFlags & ReaderSerialExportFlag)
        entry.append(readerEntry->readerSerial());
    if (exportFlags & ReaderAntennaExportFlag)
    {
        if(antennaEntry == 0)
            entry.append("1");
        else
            entry.append(QString::number(antennaEntry->antennaId()));
    }



    return entry;
}
